<div id="access_js" class="col-md-12">
    {!! Form::open() !!}
    <div class="form-group">
        <label style="font-weight: normal;">Allowed country for user <strong>{{ $user->username }}</strong> <span class="glyphicon glyphicon-question-sign text-primary" title="By default user has access to all nets. Restrict access by selecting them in input box." data-toggle="tooltip" data-placement="right"></span></label>
        <div class="clearfix">
            {!! Form::select('country[]', $country, $file, [
                'style' => 'width: 100%;',
                'multiple' => '',
                'id' => 'country',
            ]) !!}
        </div>
    </div>
    <div class="form-group">
        <label class="checkbox" style="padding-left: 20px; font-weight: normal;">
            <input class="checkbox-allow-all" type="checkbox">
            Allow access to all
        </label>
    </div>
    {!! Form::button('update', 'Update', ['class' => 'btn btn-success']) !!}
    {!! Form::close() !!}
</div>

<script>
    $('#country').select2({
        placeholder: "Country..",
        tags: true,
        allowClear: true,
        tokenSeparators: [',', ' ']
    }).data('select2').$container.addClass("input-sm").css('padding', 0);


    $(document).ready(function() {
        var $scopeWidget = $('#access_js');
        var $selectNets = $('select[name="country[]"]', $scopeWidget);
        var $checkboxAllowAll = $('.checkbox-allow-all', $scopeWidget);

        $scopeWidget.show();
        $selectNets.select2({
            placeholder: 'Allow access to all'
        });
        $('[data-toggle="tooltip"]', $scopeWidget).tooltip();

        var clickedCheckboxAllowAll = false;
        $selectNets.on('change', function() {
            if ( ! clickedCheckboxAllowAll ) {
                $checkboxAllowAll.prop('checked', false);
            }
            clickedCheckboxAllowAll = false;

            if ( ! $(':selected', $(this)).length ) {
                $checkboxAllowAll.prop('checked', true);
            }
        });
        $checkboxAllowAll.on('click', function() {
            if ( $(this).prop('checked') ) {
                clickedCheckboxAllowAll = true;
                $selectNets
                        .children('option')
                        .prop('selected', false)
                        .end()
                        .trigger('change');
            }
        });
    });
</script>